<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\booth;
use App\voter;
use App\anubhag;

class EntryController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $booths = booth::all();
        return view('entry')->with(['booths'=>$booths]);
    }
   
    /* Save Entry in Database */

    public function saveEntry(Request $req)
    {
        $req->validate([
                        'firstName' => 'required',
                        'lastName' => 'required',
                        'fatherName' => 'required',
                        'gender' => 'required',
                        'houseNo' => 'required',
                        'age' => 'required',
                        'voterid' => 'required',
                        'booth' => 'required',
                        'anubhag' => 'required'
                    ]);
        $voter = new voter;
        $voter->name = $req->firstName;
        $voter->lastName = $req->lastName;
        $voter->fathersName = $req->fatherName;
        // $voter->husbandsName = "";
        // $voter->mothersName = ""; 
        $voter->houseNo = $req->houseNo;
        $voter->age = $req->age;
        $voter->gender = $req->gender;
        $voter->voterId = $req->voterid;
        $voter->anubhagId = $req->anubhag;
        $voter->list = "U";
        $voter->timestamps = false;
        $voter->save();
        return redirect('/entry')->with('response',"Entry is successfully added..");
    }

    public function searchname(Request $req)
    {
        if(isset($req->submit))
        {
            if(strpos($req->name," "))
            {
                $a=explode(" ",$req->name);
                $voters = voter::where('name','like',$a[0].'%')
                            ->where('lastName','like',$a[1].'%');
            }
            else{
                            $voters = voter::where('name','like',$req->name.'%')
                            ->orWhere('lastName','like',$req->name.'%');
            }
            $voters = $voters->paginate();
            return view('searchname')->with(['voters' => $voters]); 
        }

    }

    public function deletevoter($id)
    {
        $voter = voter::destroy($id);
        return back()->withInput(['response' => "Voter data Deleted Successfully.."]);
    }
}
