<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\booth;
use App\voter;
use DB;
use App\anubhag;

class dashboardController extends Controller
{

	public function __construct()
    {
        $this->middleware('auth');
    }
	

	public function show(){
		$all = voter::count();
		$male = voter::where('gender','=','Male')->count();
		$female = voter::where('gender','=','Female')->count();
		$booths = booth::paginate(10);
		return view('dashboard')->with(['all'=>$all, 'male' => $male, 'female' => $female, 'booths' => $booths]);
	}



	public function anubhagList($id){
		$anubhags = anubhag::where('boothId','=',$id)->get()->toJson();
		return $anubhags;
	}


	public function advance(Request $request){

		if(! isset($request->submit)){
			$booths = booth::all();
			return view('advance')->with(['booths'=>$booths]);
		}
		
		else{
			// Anubhag
			if($request->anubhag){
				$voters = voter::where('anubhagId','=',$request->anubhag);
			}elseif($request->booth){
				$voters = voter::whereIn('anubhagId',booth::find($request->booth)->anubhags());
			}else{
				$voters = voter::where('id','>','-1');
			}

			// Gender
			if(isset($request->gender)){
				$voters = $voters->where('gender','=',$request->gender);
			}

			// Age
			if(isset($request->ageExact)){

				// Exact
				$voters = $voters->where('age','=',$request->ageExact);

			}else{

				// Range
				if(isset($request->ageMin)){
					$voters = $voters->where('age','>',$request->ageMin);
				}

				if(isset($request->ageMax)){
					$voters = $voters->where('age','<',$request->ageMax);
				}
			}

			if(isset($request->lastName)){
				$voters = $voters->where('lastName','like',$request->lastName)
					->orWhere('fathersName','like',$request->lastName);
			}

			$count = $voters->count();
			
			$voters = $voters->paginate();
			$booths = booth::all();
			return view('advance')->with(['voters'=>$voters, 'booths'=>$booths,'count'=>$count]);

		}

	}

	public function booth(Request $request){

		if(! isset($request->submit)){
			$booths = booth::all();
			return view('booth')->with(['booths'=>$booths]);
		}
		
		else{
			// Anubhag
			if($request->anubhag){
				$voters = voter::where('anubhagId','=',$request->anubhag);
			}elseif($request->booth){
				$voters = voter::whereIn('anubhagId',booth::find($request->booth)->anubhags());
			}else{
				$voters = voter::where('id','>','-1');
			}

			$count = $voters->count();
			// $male = $voters->where('gender', '=', 'Male')->count();
			// $female = $voters->where('gender', '=', 'Female')->count();
			$voters = $voters->paginate();

			$booths = booth::all();
			return view('booth')->with(['voters'=>$voters, 'booths'=>$booths,'count'=>$count]);

		}

	}



	public function age(Request $request){

		if(! isset($request->submit)){
			$booths = booth::all();
			return view('age')->with(['booths'=>$booths]);
		}
		
		else{
			
			if(isset($request->ageExact)){

				// Exact
				$voters = voter::where('age','=',$request->ageExact);

			}else{

				// Range
				if(isset($request->ageMin)){
					$voters = voter::where('age','>',$request->ageMin);
				}

				if(isset($request->ageMax)){
					$voters = voter::where('age','<',$request->ageMax);
				}
			}

			

			$count = $voters->count();
			// $male = $voters->where('gender', '=', 'Male')->count();
			// $female = $voters->where('gender', '=', 'Female')->count();
			$voters = $voters->paginate();

			$booths = booth::all();
			return view('age')->with(['voters'=>$voters, 'booths'=>$booths,'count'=>$count]);

		}

	}



	public function cast(Request $request){

		if(! isset($request->submit)){
			$booths = booth::all();
			return view('cast')->with(['booths'=>$booths]);
		}
		
		else{
			
		
			if(isset($request->lastName)){
				$voters = voter::where('lastName','like',$request->lastName)
					->orWhere('fathersName','like',$request->lastName);
				// 	->orWhere('husbandsName','like',$request->lastName)
				// 	->orWhere('mothersName','like',$request->lastName)
			}

			$count = $voters->count();
			$male = $voters->where('gender', '=', 'Male')->count();
			$female = $voters->where('gender', '=', 'Female')->count();
			$voters = $voters->paginate();

			$booths = booth::all();
			return view('cast')->with(['voters'=>$voters, 'booths'=>$booths,'count'=>$count, 'male' => $male, 'female' => $female]);

		}

	}


	public function families(Request $request){

		if(! isset($request->submit)){
			$booths = booth::all();
			return view('families')->with(['booths'=>$booths]);
		}
		
		else{

			if($request->anubhag){
				$voters = DB::select("select * from (SELECT COUNT(id) as ct, fathersName, anubhagId FROM voters WHERE fathersName != '' and anubhagId = ".$request->anubhag." GROUP BY fathersName, anubhagId ORDER BY COUNT(id) DESC) as tb where tb.ct > ".($request->familySize - 1));
			}elseif ($request->booth){
				$voters = DB::select("select * from (SELECT COUNT(id) as ct, fathersName, anubhagId FROM voters WHERE fathersName != '' and anubhagId in (".implode(',',booth::find($request->booth)->anubhags()).") GROUP BY fathersName, anubhagId ORDER BY COUNT(id) DESC) as tb where tb.ct > ".($request->familySize - 1));
			}else{
				$voters = DB::select("select * from (SELECT COUNT(id) as ct, fathersName, anubhagId FROM voters WHERE fathersName != '' GROUP BY fathersName, anubhagId ORDER BY COUNT(id) DESC) as tb where tb.ct > ".($request->familySize - 1));
			}
			
			$booths = booth::all();

			return view('families')->with(['voters'=>$voters, 'booths'=>$booths]);

		}

	}


}
