@extends('layout')



@section('content')


@if (session('response'))
    <div class="alert alert-success">
        {{ session('response') }}
    </div>
@endif


<form action="{{url('/')}}/advance" method="get">



	<div class="row">

		<div class="col-md-6">

			<h4>Select Booth Name</h4>

			<select name="booth" class="form-control" id="booth">

				<option value="0" selected="selected">Select Booth</option>

				@foreach($booths as $booth)

					<option value="{{$booth->id}}">{{$booth->id}} - {{$booth->name}}</option>

				@endforeach

			</select>

		</div>

		<div class="col-md-6">

			<h4>Select Anubhag Name</h4>

			<select name="anubhag" class="form-control" id="anubhag">

			</select>

		</div>

	</div>



	<div class="row">

		<div class="col-md-6">

			<div class="row">

				<div class="col-md-8" >

					<h4>

						Age Range

					</h4>

					<div class="row">

						<div class="col-md-6">

							<input type="number" name="ageMin" placeholder="Range Minimum" class="form-control">

						</div>

						<div class="col-md-6">

							<input type="number" name="ageMax" placeholder="Range Maximum" class="form-control">

						</div>

					</div>

				</div>

				<div class="col-md-4">

					<h4>

						Exact Age

					</h4>

					<div class="row">

						<div class="col-md-12">

							<input type="number" name="ageExact" placeholder="Exact Age" class="form-control">

						</div>

					</div>

				</div>

			</div>

		</div>

		<div class="col-md-6">

			<div class="row">

				<div class="col-md-6">

					<h4>Gender</h4>

					<div class="row">

						<div class="col-md-4">

							<input type="radio" value="Male" name="gender">Male

						</div>

						<div class="col-md-4">

							<input type="radio" value="Female" name="gender">Female

						</div>

						<div class="col-md-4">

							<input type="radio" value="NA" name="gender">NA

						</div>

					</div>

				</div>

				<div class="col-md-6">

					<h4>Last Name</h4>

					<input type="text" name="lastName" class="form-control">

				</div>

			</div>

		</div>

	</div>

	<br>

	<div class="row">

		<div class="col-md-12">

			<input type="submit" name="submit" value="submit" value="Run Querry" class="form-control" style="background-color: #8CBF4E; color: white">

		</div>

	</div>

	

</form>





<hr>



<div class="row">

	<div class="col-md-12">

		<h1>

			Result Table  

			@if(isset($count))

			 (Total {{$count}} Results)

			@endif

		</h1>

		<table style="width: 100%;">

			<thead>

				<th>

					Voter ID

				</th>

				<th>

					First Name

				</th>

				<th>

					Last Name

				</th>

				<th>

					Father's Name

				</th>

				<th>

					House No

				</th>

				<th>

					Age

				</th>

				<th>

					Gender

				</th>

				<th>

					Anubhag

				</th>

				<th>

					Booth

				</th>

				<th>

					Action

				</th>
			</thead>

			<tbody>

				@if( ! empty($voters))

					@foreach($voters as $voter)

						<tr>

							<td>

								{{$voter->voterId}}

							</td>

							<td>

								{{$voter->name}}

							</td>

							<td>

								{{$voter->lastName}}

							</td>

							<td>

								{{$voter->fathersName}}

								{{$voter->husbandsName}}

								{{$voter->mothersName}}

							</td>

							<td>

								{{$voter->houseNo}}

							</td>

							<td>

								{{$voter->age}}

							</td>

							<td>

								{{$voter->gender}}

							</td>

							<td>

								{{$voter->anubhag()}}

							</td>

							<td>

								{{$voter->booth()}}

							</td>

							<td>

								<a href="{{url('/delete',$voter->id)}}" class="btn btn-danger">
									Delete
								</a>

							</td>

						</tr>

					@endforeach

				@endif

			</tbody>

		</table>

	</div>

</div>



<br>



@if( ! empty($voters))

<div class="row">

	<div class="col-md-6">

		{{$voters->links()}}

	</div>

	<div class="col-md-6">

		<a href="" class="btn btn-success" id="excel" style="float: right;">Download Excel</a>

	</div>	

</div>

@endif



@endsection





